-- MySQL dump 10.13  Distrib 8.0.24, for Win64 (x86_64)
--
-- Host: 127.0.0.1    Database: clrkz
-- ------------------------------------------------------
-- Server version	8.0.29

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `golf_clubs`
--

DROP TABLE IF EXISTS `golf_clubs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_clubs` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_clubs`
--

LOCK TABLES `golf_clubs` WRITE;
/*!40000 ALTER TABLE `golf_clubs` DISABLE KEYS */;
/*!40000 ALTER TABLE `golf_clubs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_companies`
--

DROP TABLE IF EXISTS `golf_companies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_companies` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_companies`
--

LOCK TABLES `golf_companies` WRITE;
/*!40000 ALTER TABLE `golf_companies` DISABLE KEYS */;
/*!40000 ALTER TABLE `golf_companies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_courses`
--

DROP TABLE IF EXISTS `golf_courses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_courses` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_courses`
--

LOCK TABLES `golf_courses` WRITE;
/*!40000 ALTER TABLE `golf_courses` DISABLE KEYS */;
INSERT INTO `golf_courses` VALUES (1,'Norman',1),(2,'Faldo',1);
/*!40000 ALTER TABLE `golf_courses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_divisions`
--

DROP TABLE IF EXISTS `golf_divisions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_divisions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_divisions`
--

LOCK TABLES `golf_divisions` WRITE;
/*!40000 ALTER TABLE `golf_divisions` DISABLE KEYS */;
INSERT INTO `golf_divisions` VALUES (1,'Player',1),(2,'Sponsor',1);
/*!40000 ALTER TABLE `golf_divisions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_player_other_infos`
--

DROP TABLE IF EXISTS `golf_player_other_infos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_player_other_infos` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `player_id` bigint DEFAULT NULL,
  `user_id` bigint DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  `club_id` bigint DEFAULT NULL,
  `flight_user_id` bigint DEFAULT NULL,
  `index` varchar(100) DEFAULT NULL,
  `hcdp` varchar(100) DEFAULT NULL,
  `handicap` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `golf_player_other_infos_fk1_idx` (`player_id`),
  KEY `golf_player_other_infos_fk2_idx` (`user_id`),
  KEY `golf_player_other_infos_fk3_idx` (`flight_user_id`),
  KEY `golf_player_other_infos_fk4_idx` (`club_id`),
  CONSTRAINT `golf_player_other_infos_fk1` FOREIGN KEY (`player_id`) REFERENCES `golf_players` (`id`),
  CONSTRAINT `golf_player_other_infos_fk2` FOREIGN KEY (`user_id`) REFERENCES `golf_users` (`id`),
  CONSTRAINT `golf_player_other_infos_fk3` FOREIGN KEY (`flight_user_id`) REFERENCES `golf_users` (`id`),
  CONSTRAINT `golf_player_other_infos_fk4` FOREIGN KEY (`club_id`) REFERENCES `golf_clubs` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_player_other_infos`
--

LOCK TABLES `golf_player_other_infos` WRITE;
/*!40000 ALTER TABLE `golf_player_other_infos` DISABLE KEYS */;
/*!40000 ALTER TABLE `golf_player_other_infos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_player_status`
--

DROP TABLE IF EXISTS `golf_player_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_player_status` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_player_status`
--

LOCK TABLES `golf_player_status` WRITE;
/*!40000 ALTER TABLE `golf_player_status` DISABLE KEYS */;
INSERT INTO `golf_player_status` VALUES (1,'Invited ',1),(2,'Paid ',1),(3,'Unpaid',1),(4,'Disable',1);
/*!40000 ALTER TABLE `golf_player_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_players`
--

DROP TABLE IF EXISTS `golf_players`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_players` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `year` int DEFAULT NULL,
  `course_id` bigint DEFAULT NULL,
  `team_id` bigint DEFAULT NULL,
  `division_id` bigint DEFAULT NULL,
  `user_id` bigint DEFAULT NULL,
  `course` varchar(45) DEFAULT NULL,
  `flight` varchar(45) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `golf_players_fk1_idx` (`course_id`),
  KEY `golf_players_fk2_idx` (`division_id`),
  KEY `golf_players_fk3_idx` (`team_id`) /*!80000 INVISIBLE */,
  KEY `golf_players_fk4_idx` (`user_id`),
  CONSTRAINT `golf_players_fk1` FOREIGN KEY (`course_id`) REFERENCES `golf_courses` (`id`),
  CONSTRAINT `golf_players_fk2` FOREIGN KEY (`division_id`) REFERENCES `golf_divisions` (`id`),
  CONSTRAINT `golf_players_fk3` FOREIGN KEY (`team_id`) REFERENCES `golf_teams` (`id`),
  CONSTRAINT `golf_players_fk4` FOREIGN KEY (`user_id`) REFERENCES `golf_users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_players`
--

LOCK TABLES `golf_players` WRITE;
/*!40000 ALTER TABLE `golf_players` DISABLE KEYS */;
/*!40000 ALTER TABLE `golf_players` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_positions`
--

DROP TABLE IF EXISTS `golf_positions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_positions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_positions`
--

LOCK TABLES `golf_positions` WRITE;
/*!40000 ALTER TABLE `golf_positions` DISABLE KEYS */;
/*!40000 ALTER TABLE `golf_positions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_teams`
--

DROP TABLE IF EXISTS `golf_teams`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_teams` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_teams`
--

LOCK TABLES `golf_teams` WRITE;
/*!40000 ALTER TABLE `golf_teams` DISABLE KEYS */;
/*!40000 ALTER TABLE `golf_teams` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_users`
--

DROP TABLE IF EXISTS `golf_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_users` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `firstname` varchar(95) DEFAULT NULL,
  `middlename` varchar(95) DEFAULT NULL,
  `lastname` varchar(95) DEFAULT NULL,
  `mobile` varchar(45) DEFAULT NULL,
  `email` varchar(95) DEFAULT NULL,
  `other_mobile` varchar(45) DEFAULT NULL,
  `other_email` varchar(95) DEFAULT NULL,
  `username` varchar(45) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `is_admin` tinyint DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `last_login` datetime DEFAULT NULL,
  `company_id` bigint DEFAULT NULL,
  `position_id` bigint DEFAULT NULL,
  `active` tinyint DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_users`
--

LOCK TABLES `golf_users` WRITE;
/*!40000 ALTER TABLE `golf_users` DISABLE KEYS */;
INSERT INTO `golf_users` VALUES (1,'Clarence','Acedera','Andaya','9389592854','clarenceandaya8@gmail.com',NULL,NULL,'clrkz','$2y$10$WllXm6G1LKwuzyocGyjrWe04DmUbRGXDnsyH3Fmt.IYawAHVZdmuW',1,NULL,NULL,NULL,NULL,NULL,1,1);
/*!40000 ALTER TABLE `golf_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_users_login_session_token`
--

DROP TABLE IF EXISTS `golf_users_login_session_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_users_login_session_token` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `user_id` bigint DEFAULT NULL,
  `token` varchar(95) DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id_UNIQUE` (`user_id`),
  KEY `login_token_fk1_idx` (`user_id`),
  CONSTRAINT `login_token_fk1` FOREIGN KEY (`user_id`) REFERENCES `golf_users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_users_login_session_token`
--

LOCK TABLES `golf_users_login_session_token` WRITE;
/*!40000 ALTER TABLE `golf_users_login_session_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `golf_users_login_session_token` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2022-07-08 16:36:07
